'------------------------------------------------------------------------------
' This program is Copyright (c) 2005 Microsoft Corporation.
'
' All rights reserved.
'
' THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
' ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
' THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
' PARTICULAR PURPOSE.
'
' IN NO EVENT SHALL MICROSOFT AND/OR ITS RESPECTIVE SUPPLIERS BE
' LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
' DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
' WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
' ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
' OF THIS CODE OR INFORMATION.
'------------------------------------------------------------------------------
'
'     Loader for command lines, with end of process control - v1.8
'
'     1 - ISA Log Extraction (calling another script)
'     2 - file compression (winzip with command line add-on)
'     3a - Ftp command file creation
'     3b - Ftp file transfert to another server
'
'     Concept : build and execute command lines
'               wait for the end of process before next command line
'
'     Argument : String to search into ISA logs, used to call script
'
'     Microsoft Consulting Services - jcornier@microsoft.com - 2005/01
'------------------------------------------------------------------------------

Option Explicit

call Main()

'------------------------------------------------------------------------------
'    Main procedure
'------------------------------------------------------------------------------
Sub Main()
    Dim objShell, objArgs, objWMIService, oFile
    Dim strCommand, strFileName, strSearchString, strCurrDir, strFtpScript
    Dim strScriptName, strFieldsFile

    ' Default Values
    strSearchString = ""
    strScriptName = "ISA_Extract_Logs_v1.7.vbs"
    strFtpScript = "ftpscript.txt"
    strFieldsFile = "loglist.txt"

    ' Set current path for files (strCurrDir)
    '--------------------------------------------------------------------------
    Set oFile = WScript.CreateObject("Scripting.FileSystemObject")
    strCurrDir = oFile.GetAbsolutePathName(".") & "\"
    Set oFile = Nothing

    ' Set Objects
    '--------------------------------------------------------------------------
    Set objShell = WScript.CreateObject("WScript.shell")
    Set objArgs = WScript.Arguments

    ' Set Search String
    '--------------------------------------------------------------------------
    If (objArgs.Count - 1) < 0 Then
        WScript.Echo "Purpose of this script is to make easy scheduling of" & _
            VbCrLf & _
            "ISA Server 2004 Logs extraction calling a script with arguments." & _
            VbCrLf & VbCrLf & _
            "It chain three commands :" & VbCrLf & _
            "     1 - Launch script ISA_Extract_Logs_v1.7.vbs" & VbCrLf & _
            "     2 - Compress result file (using WinZip command line)" & VbCrLf & _
            "     3 - Ftp transfert file to another server" & _
            VbCrLf & VbCrLf & _
            "Usage :" & VbCrLf & _
            "     Call_Log_v1.7.vbs <string to search into logs>"
        WScript.Quit(-1)
    End If
    strSearchString = objArgs(0)

    ' Set Log File Name
    '--------------------------------------------------------------------------
    If InStr(strSearchString, "*") Then
        strFileName = strDate(Date() - 1) & "_" & "ISALog"
    Else
        strFileName = strDate(Date() - 1) & "_" & strSearchString
    End If

    '- Step 1 -----------------------------------------------------------------
    ' Run Log extraction
    '--------------------------------------------------------------------------
    strCommand = Chr(34) & strCurrDir & strScriptName & Chr(34) & " " & _
                 "/u " & Chr(34) & strSearchString & Chr(34) & " " & _
                 "/r " & Chr(34) & strFileName & ".log" & Chr(34) & " " & _
                 "/m 20000 /i 10 /LastDay /Load " & _
                 "/f " & Chr(34) & strCurrDir & strFieldsFile & _
                 Chr(34) & " " & "/s " & Chr(34) & " ; " & Chr(34)
    ' Debug purpose
    'WScript.Echo strCommand

    objShell.Run strCommand, 1, TRUE

    ' Wait for process to end
    '--------------------------------------------------------------------------
    call WaitForProcess(strScriptName)
    'WScript.Echo "End Log"

    '- Step 2 -----------------------------------------------------------------
    ' Run file compression
    '--------------------------------------------------------------------------
    strCommand = Chr(34) & "C:\Program Files\WinZip\WZZIP.EXE" & Chr(34) & _
                 " -m -ybc -ex " & _
                 Chr(34) & strCurrDir & strFileName & ".zip" & Chr(34) & " " & _
                 Chr(34) & strCurrDir & strFileName & ".log" & Chr(34)
    ' Debug purpose
    'WScript.Echo strCommand

    objShell.Run strCommand, 1, TRUE

    ' Wait for process to end
    '--------------------------------------------------------------------------
    call WaitForProcess(strFileName & ".zip")
    'WScript.Echo "End Zip"

    '- Step 3 -----------------------------------------------------------------
    ' Run Ftp transfert
    '--------------------------------------------------------------------------
    ' Create Ftp command file
    strFtpScript = strCurrDir & strFtpScript
    call LogAction(strFtpScript, "open 192.168.0.1", TRUE)
    call LogAction(strFtpScript, "User1", FALSE)
    call LogAction(strFtpScript, "password", FALSE)
    call LogAction(strFtpScript, "cd log_files", FALSE)
    strCommand = "lcd " & Chr(34) & _
        Left(strCurrDir, Len(strCurrDir) - 1) & Chr(34)
    call LogAction(strFtpScript, strCommand, FALSE)
    call LogAction(strFtpScript, "binary", FALSE)
    call LogAction(strFtpScript, "hash", FALSE)
    call LogAction(strFtpScript, "prompt", FALSE)
    strcommand = "put " & Chr(34) & strCurrDir & strFileName & ".zip" & Chr(34)
    call LogAction(strFtpScript, strcommand, FALSE)
    call LogAction(strFtpScript, "quit", FALSE)

    ' File transfert
    strCommand = "ftp -s:" & Chr(34) & strFtpScript & Chr(34)
    objShell.Run strCommand, 1, TRUE

    ' Wait for process to end
    '--------------------------------------------------------------------------
    call WaitForProcess(strFtpScript)
    'WScript.Echo "End Ftp"

    ' Clear Objects
    '--------------------------------------------------------------------------
    Set objShell = Nothing
    Set objArgs = Nothing
End Sub

'------------------------------------------------------------------------------
'                         End of main code
'                   Start of procedures and functions
'------------------------------------------------------------------------------

'----------------------------------------------------------------
'    Purpose : Build a Date string
'    Return : YearMonthDate, format "yyyymmdd"
'----------------------------------------------------------------
Function strDate(dDate)
    Dim strToday, strMonth, strDay, strYear

    strToday = dDate
    strMonth = Month(strToday)
    strDay = Day(strToday)
    If Len(strMonth) < 2 Then strMonth = "0" & strMonth End If
    If Len(strDay) < 2 Then strDay = "0" & strDay End If
    strDate = Year(strToday) & strMonth & strDay
End Function

'----------------------------------------------------------------
'    Purpose : Add new line into a texte file
'             Create file if needed
'    Arguments : Name of file
'            line to write
'            Create or append
'----------------------------------------------------------------
Sub LogAction(strFileLog, strStringToLog, bCreate)
    Dim oFileLog
    Dim TxtLog

    ' Open file
    Set oFileLog = WScript.CreateObject("Scripting.FileSystemObject")

    If bCreate = TRUE Then
        Set TxtLog = oFileLog.OpenTextFile (strFilelog, 2, True)
    Else
        Set TxtLog = oFileLog.OpenTextFile (strFileLog, 8, True)
    End If

    ' Write line
    TxtLog.Writeline strStringToLog

    ' Close file
    TxtLog.close
    Set oFileLog = Nothing
 End Sub

'----------------------------------------------------------------
'    Purpose : Wait for the end of a process
'    Arguments :
'----------------------------------------------------------------
Sub WaitForProcess(strScript)
    Dim strComputer
    Dim objWMIService, objProcess
    Dim colProcesses
    Dim bScriptIsRunning

    strComputer = "."
    Set objWMIService = GetObject("winmgmts:" _
        & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")

    bScriptIsRunning = TRUE

    Do While bScriptIsRunning
        bScriptIsRunning = FALSE
        WScript.Sleep 15000

        ' query for "script" processes
        Set colProcesses = objWMIService.ExecQuery _
            ("SELECT * FROM Win32_Process")
            '("SELECT * FROM Win32_Process WHERE Name = " & _
            '    "'Wscript.exe' OR Name = 'Cscript.exe'")

        If colProcesses.Count = 0 Then
            bScriptIsRunning = TRUE
        Else
            For Each objProcess in colProcesses
                ' look for the script process corresponding to the cmd line
                IF InStr(objProcess.CommandLine, strScript) Then
                    bScriptIsRunning = TRUE
                End If
            Next
        End If
        Set colProcesses = Nothing
    Loop

    Set objWMIService = Nothing
End Sub

